/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.ThrownWaterball;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class WaterDragon
extends EntityLiving {
    public WaterDragon(World w) {
        super(w);
        this.maxrenderdist = 180;
        this.uniquename = "OreSpawn:WaterDragon";
        this.moveSpeed = 0.31f;
        this.movefrequency = 55;
        this.canSwim = true;
        this.canBreateUnderWater = true;
        this.swimoffset = -2.25f;
        this.setExperience(200);
        this.height = 2.25f;
        this.width = 1.95f;
        this.setMaxHealth(300.0f);
        this.setHealth(300.0f);
        this.setDefense(2.5f);
        this.setAttackDamage(35.0f);
        this.searchDistance = 30.0f;
        this.attackRange = 3.0f;
        this.isImmuneToFire = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.tower_defense_enable = true;
        this.enable_findfoodblock = true;
        this.foodblockfreq = 10;
        this.foodblockdistxz = 16;
        this.foodblockdisty = 5;
        this.foodblockheal = 0;
        this.foodblockdisteat = 0;
        this.fooddaytimeonly = false;
        this.enableBreeding(10);
        this.enableTaming(20);
        this.findbuddydistance = 16;
        this.findbuddyfrequency = 6;
    }

    public boolean isBuddy(Entity e) {
        return e instanceof WaterDragon && !e.isBaby();
    }

    public boolean isBreedingFoodForMe(int bid, int iid) {
        if (iid == Items.fishmeat.itemID) {
            return true;
        }
        return iid == OreSpawnMain.crystalapple.itemID;
    }

    public void doEntityAction(float deltaT) {
        this.enable_buddy = this.enable_buddy_nearest = this.isBaby();
        if (this.getInLiquid()) {
            this.moveSpeed = 0.76f;
            this.enable_findfoodblock = false;
            if (this.world.rand.nextInt(20) == 1) {
                this.heal(1.0f);
            }
        } else {
            this.moveSpeed = 0.32f;
            this.enable_findfoodblock = true;
        }
        super.doEntityAction(deltaT);
    }

    public void doDistanceAttack(Entity victim) {
        if (this.world.isServer) {
            ThrownWaterball e = (ThrownWaterball)this.world.createEntityByName("OreSpawn:ThrownWaterball", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * this.width * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 4.0f / 5.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * this.width), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * this.width * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setBID(0);
                e.setIID(OreSpawnMain.waterball.itemID);
                e.thrower = this;
                e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(this.rotation_pitch_head))), (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), 4.5f, 0.2f);
                this.world.spawnEntityInWorld((Entity)e);
            }
            this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
    }

    public boolean isFoodBlock(int bid) {
        return bid == Blocks.water.blockID || bid == Blocks.waterstatic.blockID;
    }

    public boolean isFoodItem(int iid) {
        return iid == Items.fishmeat.itemID;
    }

    public void doEatFoodAction(int d, int x, int y, int z) {
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean() && this.getInLiquid()) {
            return "DangerZone:little_splash";
        }
        return null;
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "OreSpawn:waterdragon_hurt1";
        }
        if (which == 1) {
            return "OreSpawn:waterdragon_hurt2";
        }
        return "OreSpawn:waterdragon_hurt3";
    }

    public String getDeathSound() {
        return "OreSpawn:waterdragon_death";
    }

    public void doDeathDrops() {
        int howmany = 5 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.fishmeat.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.waterdragonscale.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophywaterdragon.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof WaterDragon) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/WaterDragontexture.png");
        }
        return this.texture;
    }
}

